const LoanApplication = require('../models/LoanApplication');

// @desc    Submit a new loan application
// @route   POST /api/loans/apply
// @access  Public
exports.applyForLoan = async (req, res) => {
  try {
    const { 
      fullName, 
      email, 
      phone, 
      loanType, 
      loanAmount, 
      employmentStatus, 
      annualIncome 
    } = req.body;

    // Create the application
    const application = await LoanApplication.create({
      fullName,
      email,
      phone,
      loanType,
      loanAmount,
      employmentStatus,
      annualIncome
    });

    res.status(201).json({
      success: true,
      message: 'Application submitted successfully! We will review it shortly.',
      data: application
    });

  } catch (error) {
    // Handle Mongoose validation errors
    if (error.name === 'ValidationError') {
      const messages = Object.values(error.errors).map(val => val.message);
      return res.status(400).json({
        success: false,
        error: messages
      });
    }

    res.status(500).json({
      success: false,
      error: 'Server Error'
    });
  }
};