const mongoose = require("mongoose");

const cardRequestSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "User",
    required: true,
  },
  cardType: {
    type: String,
    enum: ["Debit", "Credit"],
    required: true,
  },
  status: {
    type: String,
    enum: ["pending", "approved", "declined"],
    default: "pending",
  },
  cardNumber: {
    type: String,
    minlength: 16,
    maxlength: 16,
    select: false, // Only queried manually or when approved
  },
  expiryDate: {
    type: String, // e.g., "12/28"
  },
  cvv: {
    type: String,
    minlength: 3,
    maxlength: 4,
    select: false,
  },
  createdAt: {
    type: Date,
    default: Date.now,
  },
});


module.exports = mongoose.model('CardRequest', cardRequestSchema);
