const mongoose = require('mongoose');

const GrantApplicationSchema = new mongoose.Schema({
  // Distinguish between the two types
  applicationType: {
    type: String,
    required: true,
    enum: ['individual', 'company'], 
    index: true // Helps search faster
  },

  // Fields for Individual Applicants
  fullName: {
    type: String,
    required: function() { return this.applicationType === 'individual'; }
  },
  idNumber: {
    type: String,
    required: function() { return this.applicationType === 'individual'; }
  },

  // Fields for Company Applicants
  companyName: {
    type: String,
    required: function() { return this.applicationType === 'company'; }
  },
  ein: { // Tax ID / EIN
    type: String,
    required: function() { return this.applicationType === 'company'; }
  },

  // Shared Fields
  projectDescription: {
    type: String,
    required: [true, 'Please provide a project description']
  },
  
  status: {
    type: String,
    enum: ['pending', 'under_review', 'approved', 'rejected'],
    default: 'pending'
  },
    user: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User'
  },

}, { timestamps: true }); // Automatically adds createdAt and updatedAt

module.exports = mongoose.model('GrantApplication', GrantApplicationSchema);