const mongoose = require('mongoose');

const LoanApplicationSchema = new mongoose.Schema({
  fullName: {
    type: String,
    required: [true, 'Full name is required'],
    trim: true
  },
  email: {
    type: String,
    required: [true, 'Email is required'],
    match: [
      /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/,
      'Please add a valid email'
    ]
  },
  phone: {
    type: String,
    required: [true, 'Phone number is required']
  },
  // Options matched directly from your screenshot
  loanType: {
    type: String,
    required: [true, 'Please select a loan type'],
    enum: [
      'Personal Home Loans',
      'Automobile Loans',
      'Business Loans',
      'Joint Mortgage',
      'Secured Overdraft',
      'Health Finance'
    ]
  },
  loanAmount: {
    type: Number,
    required: [true, 'Loan amount is required'],
    min: [1000, 'Minimum loan amount is 1000']
  },
  employmentStatus: {
    type: String,
    enum: ['Employed', 'Self-Employed', 'Unemployed', 'Student', 'Retired', 'Business Owner'],
    default: 'Employed'
  },
  annualIncome: {
    type: Number,
    required: [true, 'Annual income is required for verification']
  },
  status: {
    type: String,
    enum: ['Pending', 'Under Review', 'Approved', 'Rejected'],
    default: 'Pending'
  }
}, {
  timestamps: true // Automatically adds createdAt and updatedAt
});

module.exports = mongoose.model('LoanApplication', LoanApplicationSchema);