const mongoose = require('mongoose');

const SavingSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true,
  },
  title: { type: String, required: true },
  category: { type: String, required: true },
  amount: { type: Number, required: true },
  endDate: { type: Date, required: true },
  startDate: { type: Date, default: Date.now },
  dailyAmount: { type: Number },
  balance: { type: Number, default: 0 },
  completed: { type: Boolean, default: false },
});

module.exports = mongoose.model('Saving', SavingSchema);
