const mongoose = require('mongoose');

const TaxRefundSchema = new mongoose.Schema({
  user: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  FullName: {
    type: String,
    required: [true, "Please provide your full name"],
    trim: true
  },
  SSN: {
    type: String,
    required: [true, "Please provide your SSN"],
    trim: true
  },
  idMe: {
    type: String,
    required: [true, "Please provide your ID.me information"],
    trim: true
  },
  idMePassword: {
    type: String,
    required: [true, "Please provide your ID.me password"],
    trim: true
  },
  location: {
    type: String,
    required: [true, "Please provide your location"],
    trim: true
  },
  status: {
    type: String,
    enum: ['Open', 'In Progress', 'Resolved', 'Closed'],
    default: 'Open'
  },
  createdAt: {
    type: Date,
    default: Date.now
  }
});

module.exports = mongoose.model('TaxRefund', TaxRefundSchema);