// models/Ticket.js
const mongoose = require('mongoose');

const TicketSchema = new mongoose.Schema({
  user: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User', // Links the ticket to the user who created it
    required: true
  },
  title: {
    type: String,
    required: [true, "Please provide a ticket title"],
    trim: true
  },
  priority: {
    type: String,
    enum: ['Low Priority', 'Medium Priority', 'High Priority'],
    default: 'Low Priority'
  },
  message: {
    type: String,
    required: [true, "Please include details about your issue"]
  },
  status: {
    type: String,
    enum: ['Open', 'In Progress', 'Resolved', 'Closed'],
    default: 'Open'
  },
  createdAt: {
    type: Date,
    default: Date.now
  }
});

module.exports = mongoose.model('Ticket', TicketSchema);