const mongoose = require('mongoose');

const withdrawalSchema = new mongoose.Schema({
  userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true },
  amount: { type: Number, required: true },
  withdrawalType: { type: String, enum: ['bank', 'crypto'], required: true },

  // Bank withdrawal fields
  address: String,
  accountNumber: String,
  accountType: String,
  bankName: String,
  routingNumber: String,
  accountHolder: String,
  email: String,

  // Crypto withdrawal fields
  walletAddress: String,
  network: String,
  coin: String,

  status: { type: String, enum: ['pending', 'approved', 'declined'], default: 'pending' },
}, { timestamps: true });

module.exports = mongoose.model('Withdrawal', withdrawalSchema);
