exports.getVerificationEmailTemplate = (userName, code) => {
  return `
  <div style="background-color:#f4f4f4; padding:20px; font-family:Arial, sans-serif; color:#333;">
    <div style="max-width:600px; margin:0 auto; background:white; border-radius:8px; overflow:hidden; box-shadow:0 2px 10px rgba(0,0,0,0.1);">
      <div style="background:#004080; padding:20px; color:white;">
        <h2 style="margin:0;">Titan Trust Bank</h2>
      </div>
      <div style="padding:30px;">
        <p>Hi <strong>${userName}</strong>,</p>
        <p>Thank you for completing your profile. Please use the verification code below to verify your email address:</p>
        <div style="background:#e0f7fa; padding:15px; font-size:24px; text-align:center; letter-spacing:3px; margin:20px 0;">
          <strong>${code}</strong>
        </div>
        <p>This code will expire in 15 minutes. Do not share it with anyone.</p>
        <p>Need help? Reply to this email and our support team will assist you.</p>
        <p style="margin-top:30px;">Sincerely,<br/>Titan Trust Bank Team</p>
      </div>
      <div style="background:#f1f1f1; padding:15px; text-align:center; font-size:12px; color:#777;">
        &copy; ${new Date().getFullYear()} Titan Trust Bank. All rights reserved.
      </div>
    </div>
  </div>`;
};
exports.cardApprovedEmail = (userName, cardType) => `
  <div style="font-family: Arial, sans-serif; color: #333; padding: 20px;">
    <h2 style="color: #004080;">Titan Trust Bank</h2>
    <p>Hi <strong>${userName}</strong>,</p>
    <p>We’re happy to let you know your <strong>${cardType} Card</strong> request has been approved.</p>
    <p>Your card will be processed and shipped shortly. We appreciate your trust in us.</p>
    <p>Regards,<br/>Titan Trust Bank Team</p>
  </div>
`;

exports.cardDeclinedEmail = (userName, cardType) => `
  <div style="font-family: Arial, sans-serif; color: #333; padding: 20px;">
    <h2 style="color: #990000;">Titan Trust Bank</h2>
    <p>Hi <strong>${userName}</strong>,</p>
    <p>We regret to inform you that your <strong>${cardType} Card</strong> request has been declined.</p>
    <p>A refund of $2,000 has been returned to your account.</p>
    <p>If you believe this was in error, please contact support.</p>
    <p>Thanks for choosing us,<br/>Titan Trust Bank Team</p>
  </div>
`;
