const nodemailer = require("nodemailer");
require("dotenv").config();

const sendEmail = async (to, subject, text, htmlTemplate) => {
  const transporter = nodemailer.createTransport({
    host: "mail.chop-life.com",
    port: 465,
    secure: true,
    auth: {
      user: process.env.EMAIL_USER,
      pass: process.env.EMAIL_PASS,
    },
    tls: {
      rejectUnauthorized: false,
    },
  });

  await transporter.sendMail({
    from: `"Titan Trust Bank" <${process.env.EMAIL_USER}>`,
    to,
    subject,
    text,
    html:htmlTemplate
  });
};

module.exports = sendEmail;
